
function AISMN_ReturnToSpawnPoint::OnEnter(%this, %data)
{
   %object = GetThisObject(%data);
   %spawnPoint = slgGetSpawnPtContaining(%object);
   if (%spawnPoint == 0)
   {
      return;
   }
      
   %pos = %spawnPoint.getPosition();
   SetPathToSpot(%data, getWord(%pos, 0), getWord(%pos, 1));
   %object.playThread(0, "run");
}

function AISMN_ReturnToSpawnPoint::OnExit(%this, %data)
{
   %object = GetThisObject(%data);
   %object.playThread( 0, "root");
}

// EXIT 0: DONE TRAVELING- reached the spawn point, stop walking
// EXIT 0: COMBAT AGAIN- someone else to fight, move into range
// EXIT 0: COMBAT NOW- someone else to fight, attack them now
function AISMN_ReturnToSpawnPoint::Update(%this, %data)
{
   if (IsFollowingPath(%data) == false)
   {
      ReturnValue(%data, 0);
      return;
   }
   
   // while returning to the spawn point and someone starts
   // firing at you
   if (%data.isUnderAttack() == true)
   {
	   ReturnValue(%data, 0);
      return;
   }
   
   // while returning to the spawn point and you see an
   // ally being attacked
   if (%data.allyIsUnderAttack() == true)
   {
      ReturnValue(%data, 0);
      return;
   }
   
   // while returning to the spawn point and you see someone
   // else to hunt down
   if (%data.enemyIsThreat() == true)
   {
      ReturnValue(%data, 0);
      return;
   }
   
   ReturnValue(%data, -1);
}
